#!/bin/bash
#
# Soluti Certificação Digital
# 
# Instalador SafeSign Ubuntu
# Utilização: sudo ./install.sh
#                  ou
#             sudo bash install.sh
#

APT="/usr/bin/apt-get"
DPKG="/usr/bin/dpkg"

LOG="install.log"
ID=$(id -u)
ARCH=$(uname -m | sed 's/x86_//;s/i[3-6]86/32/')

function DetectaUbuntu {
 OS=$(awk '/DISTRIB_ID=/' /etc/*-release | sed 's/DISTRIB_ID=//' | tr '[:upper:]' '[:lower:]')
 if [ -f /etc/lsb-release -a ! -z "$OS" ]; then
  echo "0"
 else
  echo "1"
 fi
}

function SafeSignInstallx86 {
 echo -e "\n\n########## Instalando SafeSign x86\n\n" >> "$LOG"
 $DPKG -i ./x86/SafeSignIC3.0.97-i386-ub1204-admin.deb >> "$LOG" 2>&1
 echo "$?"
}

function SafeSignInstallx64 {
 echo -e "\n\n########## Instalando SafeSign x64\n\n" >> "$LOG"
 $DPKG -i ./x64/SafeSignIC3.0.97-x86_64-ub1204-admin.deb >> "$LOG" 2>&1
 echo "$?"
}

function VerificaSafeSign {
 $DPKG -l | grep safesignidentityclient | grep ^ii > /dev/null 2>&1
 echo "$?"
}

function Banner {
 echo -e "\n###################################"
 echo "# "
 echo -e "#   Soluti Certificação Digital "
 echo -e "#   Instalador SafeSign Ubuntu "
 echo "# "
 echo -e "###################################\n"
}

function Suporte {
  echo "    Poderá entrar em contato pelos números:"
  echo "     * (062) 3999-6000 - Opção 2"
}

function RemoveLog {
 if [ -f $LOG ]; then
  rm -f "$LOG"
 fi
}

RemoveLog
Banner

if [ "$ID" -eq 0 ]; then
  if [ $(DetectaUbuntu) -eq 0 ]; then
    if [ "$ARCH" -eq 86 -o "$ARCH" -eq 32 ]; then
     if [ $(VerificaSafeSign) -ne 0 ]; then
      echo "[+] Instalando pacote SafeSign"
      if [ $(SafeSignInstallx86) -ne 0 ]; then
       echo "    [+] Atualizando lista de repositórios..."
       echo -e "\n\n########## Atualizando repositórios\n\n" >> "$LOG"
       $APT update >> "$LOG" 2>&1
       echo "    [+] Instalando pacotes requeridos..."
       echo -e "\n\n########## Instalando pacotes requeridos\n\n" >> "$LOG"
       $APT -f install -y >> "$LOG" 2>&1

       if [ $(SafeSignInstallx86) -eq 0 ]; then
          echo "[+] SafeSign x86 instalado com êxito!"
       else
          echo "    [-] SafeSign não foi instalado "
          Suporte
          exit
       fi
     fi

     else
      echo "[+] Pacote SafeSignx86 já está instalado"
      exit
     fi

    elif [ "$ARCH" -eq 64 ]; then

     if [ $(VerificaSafeSign) -ne 0 ]; then
      echo "[+] Instalando pacote SafeSign"
      if [ $(SafeSignInstallx64) -eq 0 ]; then
        echo "[+] SafeSign x64 instalado com êxito!"
        exit
      else
        echo "    [+] Atualizando lista de repositórios..."
        $APT update >> "$LOG" 2>&1
        echo "    [+] Instalando pacotes requeridos..."
        echo -e "\n\n########## Instalando pacotes requeridos\n\n" >> "$LOG" 2>&1
        $APT -f install -y >> "$LOG" 2>&1
 
        if [ $(SafeSignInstallx64) -eq 0 ]; then
          echo "[+] SafeSign x64 instalado com êxito!"
        else
          echo "[-] SafeSign não foi instalado"
          Suporte
          exit
        fi
      fi

     else
       echo "[+] Pacote SafeSign x64 já está instalado"
       exit
     fi

    fi
  else
   echo "[-] Script deverá ser executado na distribuição Linux Ubuntu"
   exit
  fi

else
  echo "Execute o '$0' como root!"
  exit
fi
